/*Migrated by Sakshi p
 * component : nvo_bo_asset_register
 */

package ibase.webitm.ejb.fin;

import java.rmi.RemoteException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import ibase.utility.BaseLogger;
import ibase.utility.E12GenericUtility;
import ibase.webitm.ejb.ITMDBAccessEJB;
import ibase.webitm.ejb.ValidatorEJB;
import ibase.webitm.utility.ITMException;

public class AssetRegistersIC extends ValidatorEJB{
	E12GenericUtility genericUtility = new E12GenericUtility();
	private PreparedStatement pstmt;

	public String wfValData(Document dom, Document dom1, Document dom2, String objContext, String editFlag, String xtraParams) throws RemoteException,ITMException
	{
		
		BaseLogger.log("3", getUserInfo(), null, "Inside the wfvaldata -->:" );
        String  userId= getValueFromXTRA_PARAMS(xtraParams, "loginEmpCode");
		BaseLogger.log("3", getUserInfo(), null, "userId -->:" +userId  );

        // To get user details
		String errString = "",orginalValuestr="";
		NodeList parentNodeList = null;
		NodeList childNodeList = null;
		Node parentNode = null;
		Node childNode = null;
		String childNodeName = null;
		String errCode = "";
		int cnt = 0;
		int ctr = 0;
		int childNodeListLength;
		String siteCode = "";
		String cctrCode = "";
		String itemCode = "";
		String itemSer = "";
		String currCode = "";
		String empCode = "";
		String alocCode = "";
		String assetCodeLink = "";
		double orginalValue = 0.0;
		String sql = "";
		ResultSet rs=null;
		PreparedStatement pstmt=null;
		String lsCode = "";
		double lcOldValue = 0.0;
		Timestamp ldDate1 = null;
		Timestamp ldDate2 = null;
		String mVal = "",ls_var1="",ls_grp_code="";
		int currentFormNo = 0;
		String assetClass = "",ls_code="";
		String acctPrd = "";
		String taxCode = "";
		ITMDBAccessEJB itmDbAccess = null;
		String grpCode = null;
		try
		{
			itmDbAccess = new ITMDBAccessEJB();
			FinCommon finCommon = new FinCommon();
			if(objContext != null && objContext.trim().length()>0)
			{
				currentFormNo = Integer.parseInt(objContext);
			}
			BaseLogger.log("3", getUserInfo(), null, "currentform : [" + currentFormNo+"]");

			switch( currentFormNo )
			{
			case 1:
				BaseLogger.log("3", getUserInfo(), null, "currentform : " + currentFormNo);
				parentNodeList = dom.getElementsByTagName("Detail1");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++) 
				{
					boolean isError = false;
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName == null)
					{
						continue;
					}
					childNodeName = childNodeName.trim();

					switch(childNodeName)
					{
					case "site_code":
					{
						siteCode = whenNull(getItemString(dom,1,"site_code"));
						BaseLogger.log("3", getUserInfo(), null, "site_code:::" + siteCode);
						if(siteCode != null && siteCode.trim().length() > 0)
						{
							sql = "select count(*) from site where site_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,siteCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0)
							{
								errCode = "VTSITE1";
								break;
							}

						}
						break;
					}		

					case "cctr_code":
					{
						cctrCode = checkNull(genericUtility.getColumnValue("cctr_code", dom));
						BaseLogger.log("3", getUserInfo(), null, "cctr code>>>>>>"+acctPrd);
						if(cctrCode != null && cctrCode.trim().length() > 0)
						{
							sql = "select count(*)  from costctr where cctr_code = ?";
							BaseLogger.log("3", getUserInfo(), null, "cctr_code:::" + cctrCode);
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,cctrCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0) 
							{
								if("E".equalsIgnoreCase(whenNull(insertError("VTCCTRCDPL", childNodeName))))
								{
									isError = true;
									break;
								}
							}
						}
						break;
					}
					case "item_code":
					{
						itemCode=whenNull(getItemString(dom, 1,"item_code"));
						if(itemCode==null || itemCode.trim().length()==0) 
						{
							if("E".equalsIgnoreCase(whenNull(insertError("VMITEM1", childNodeName))))
							{
								break;
							}
						}
						else 
						{
							sql="SELECT COUNT(*) FROM ITEM WHERE ITEM_CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,itemCode);
							rs=pstmt.executeQuery();
							if(rs.next())
							{
								cnt=rs.getInt(1);
							}
							rs.close();rs=null;
							pstmt.close();pstmt=null;
							if(cnt==0)
							{
								if("E".equalsIgnoreCase(whenNull(insertError("VMITEM1", childNodeName))))
								{
									break;
								}
							}
						}
						sql = "select grp_code from item where item_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, ls_code);
						rs = pstmt.executeQuery();
						if (rs.next()) {
							ls_grp_code = rs.getString(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						ls_var1 = getItemString(dom, 1, "grp_code");
						if ((!ls_var1.trim().equals(ls_grp_code.trim())))
						{
							errString = "VMASSGRP";
						}

						break;
					}
					case "item_ser":
					{
						lsCode = whenNull(genericUtility.getColumnValue("item_ser", dom));

						sql = "SELECT COUNT(1) FROM itemser	WHERE item_ser = ?";
						BaseLogger.log("3", getUserInfo(), null, "item_ser:::" + lsCode);
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, lsCode);
						rs = pstmt.executeQuery();
						if (rs.next())
						{
							cnt = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if (cnt == 0)
						{
							errCode = "VTITEMSER1";
						}

						if (errCode != null && errCode.trim().length() > 0)
						{
							if ("E".equalsIgnoreCase(insertError(errCode, "item_ser")))
							{
								break;
							}
						}

						break;
					}
					case "curr_code":
					{
						currCode = checkNull(genericUtility.getColumnValue("curr_code", dom));

						sql = "select count(*)  from currency where curr_code = ?";
						BaseLogger.log("3", getUserInfo(), null, "curr_code:::" + currCode);
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,currCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							cnt = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if(cnt == 0)
						{
							errCode = "VMCUR1";
						}

						if (errCode != null && errCode.trim().length() > 0) 
						{
							if("E".equalsIgnoreCase(this.insertError(errCode, "curr_code")))
							{
								break;
							}
						}
						break;
					}

					case "emp_code":
					{
						empCode = checkNull(genericUtility.getColumnValue("emp_code", dom));
						if(empCode != null && empCode.trim().length() > 0)
						{
							sql = "select count(*) from employee where emp_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,empCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0)
							{
								errCode = "VMEMP1";
							}
						}
						if (errCode != null && errCode.trim().length() > 0) 
						{
							if("E".equalsIgnoreCase(this.insertError(errCode, "emp_code")))
							{
								break;
							}
						}
						break;
					}
					case "aloc_code":
					{
						alocCode = checkNull(genericUtility.getColumnValue("aloc_code", dom));
						siteCode = checkNull(genericUtility.getColumnValue("site_code", dom));

						sql = "select count(*)  from asset_location where aloc_code = ? and site_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1,alocCode);
						pstmt.setString(2,siteCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							cnt = rs.getInt(1);
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
						if(cnt == 0)
						{
							errCode = "VMLOC1";
						}

						if (errCode != null && errCode.trim().length() > 0) 
						{
							if("E".equalsIgnoreCase(this.insertError(errCode, "aloc_code")))
							{
								break;
							}
						}
						break;
					}
			//Added by Amol S on 25 Feb 25  to apply validation when warranty end date --START
					case "start_date_warranty":  
					case "end_date_warranty": {  
					    String errorString = "";  
					    BaseLogger.log("3", null, null, "Inside the else block:: >>>>>");  

					    String startDateWarranty = checkNull(genericUtility.getColumnValue("start_date_warranty", dom)).trim();
					    String endDateWarranty = checkNull(genericUtility.getColumnValue("end_date_warranty", dom)).trim();

					    BaseLogger.log("3", getUserInfo(), null, "start_date_warranty [" + startDateWarranty + "]");
					    BaseLogger.log("3", getUserInfo(), null, "end_date_warranty [" + endDateWarranty + "]");

					    try {
					        SimpleDateFormat dtFormat = new SimpleDateFormat("dd/MM/yy");  
					        java.util.Date formattedStartDateWarranty = dtFormat.parse(startDateWarranty);
					        java.util.Date formattedEndDateWarranty = dtFormat.parse(endDateWarranty);

					        if (formattedStartDateWarranty.compareTo(formattedEndDateWarranty) > 0) {
					            BaseLogger.log("3", getUserInfo(), null, "Inside the if condition when end date is less ");
					            errorString = "INVLDT"; // Error code for invalid date

					            if ("E".equalsIgnoreCase(this.insertError(errorString, "start_date_warranty"))) {
					                return errorString; // Return error if insertion fails
					            }
					        }
					    } catch (ParseException pe) {
					        BaseLogger.log("3", null, null, "Parsing error: " + pe.getMessage());
					        return "Invalid date format"; // Return error if date parsing fails
					    }

					    break; // Normal case termination
					}

			//Added by Amol S on 25 Feb 25  to apply validation when warranty end date --End

					
					case "asset_code__link":
					{
						assetCodeLink = checkNull(genericUtility.getColumnValue("asset_code__link", dom));
						if(assetCodeLink != null && assetCodeLink.trim().length() > 0)
						{
							sql = "select count(*) from asset_register where asset_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,assetCodeLink);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0)
							{
								errCode = "VMASSET1";
							}
						}
						if (errCode != null && errCode.trim().length() > 0) 
						{
							if("E".equalsIgnoreCase(this.insertError(errCode, "asset_code__link")))
							{
								break;
							}
						}
						break;
					}
					case "orginal_value":
					{   
						orginalValuestr=whenNull(getItemString(dom, 1,"orginal_value"));
						if(orginalValuestr != null && orginalValuestr.trim().length() > 0)
						{
							orginalValue = Double.parseDouble(orginalValuestr);
						}				
						lsCode = whenNull(genericUtility.getColumnValue("asset_code", dom));
						if(orginalValue <= 0)
						{
							errCode = "VTASAMT";
						}
						if(editFlag.equalsIgnoreCase("E") )
						{
							if(orginalValue <= 0)
							{
								errCode = "VTASAMT";
							}
							sql = "select orginal_value from asset_register where asset_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,lsCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								lcOldValue = rs.getDouble(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(orginalValue != lcOldValue)
							{
								sql = "select count(*) from asset_depr where asset_code = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,lsCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								if(cnt > 0)
								{
									this.setItem(dom, 1, "orginal_value", Double.toString(lcOldValue));
									errCode = "VTREMDEPR";
								}
							}
						}
						if (errCode != null && errCode.trim().length() > 0) 
						{
							if("E".equalsIgnoreCase(this.insertError(errCode, "orginal_value")))
							{
								break;
							}
						}
						break;
					}

					case "proc_date_1":
					case  "proc_date_2":
					{
						String ldDate_1 = whenNull(getItemString(dom, 1, "proc_date_1"));
						String ldDate_2 = whenNull(getItemString(dom, 1, "proc_date_2"));
						if(ldDate_1 != null && ldDate_1.trim().length() > 0 && ldDate_2 != null && ldDate_2.trim().length() > 0) 
						{
							ldDate1 = Timestamp.valueOf(genericUtility.getValidDateString(ldDate_1, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00");
							ldDate2 =  Timestamp.valueOf(genericUtility.getValidDateString(ldDate_2, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00");

							if(ldDate1 != null)
							{
								if(ldDate2.before(ldDate1) )
								{
									errCode = "VTPROCDT";
								}

								if (errCode != null && errCode.trim().length() > 0) 
								{
									if("E".equalsIgnoreCase(this.insertError(errCode, childNodeName)))
									{
										break;
									}
								}
							}
						}
						break;
					}
					case "asset_class":
					{
						assetClass = checkNull(genericUtility.getColumnValue("asset_class", dom));
						if(assetClass == null || assetClass.trim().length() == 0)
						{
							errCode = "VTASTCLSNL";
						}
						else
						{
							sql = "select count(*) from asset_class where asset_class = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,assetClass);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0)
							{
								errCode = "VTASTCSIN";
							}
						}
						if (errCode != null && errCode.trim().length() > 0) 
						{
							if("E".equalsIgnoreCase(this.insertError(errCode, "asset_class")))
							{
								break;
							}
						}
						break;
					}
					case "asset_code":
					{
						lsCode = checkNull(genericUtility.getColumnValue("asset_code", dom));
						if(editFlag.equalsIgnoreCase("E"))
						{
							sql = "select count(*) from asset_installdet where asset_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,lsCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt > 0)
							{
								errCode = "VTASSSOUR";
							}
							else
							{
								sql = "select count(*) from asset_depr where asset_code = ?";
								pstmt = conn.prepareStatement(sql);
								pstmt.setString(1,lsCode);
								rs = pstmt.executeQuery();
								if(rs.next())
								{
									cnt = rs.getInt(1);
								}
								rs.close();
								rs = null;
								pstmt.close();
								pstmt = null;
								if(cnt > 0)
								{
									errCode = "VTAEDIT";
								}
								else
								{
									sql = "select count(*) from asset_depr_month where asset_code = ?";
									pstmt = conn.prepareStatement(sql);
									pstmt.setString(1,lsCode);
									rs = pstmt.executeQuery();
									if(rs.next())
									{
										cnt = rs.getInt(1);
									}
									rs.close();
									rs = null;
									pstmt.close();
									pstmt = null;
									if(cnt > 0)
									{
										errCode = "VTASEDIT";
									}
								}
							}
						}
						if (errCode != null && errCode.trim().length() > 0) 
						{
							if("E".equalsIgnoreCase(this.insertError(errCode, "asset_code")))
							{
								break;
							}
						}
					}
					}
					if(isError)
					{
						break;
					}
				}
				break;

			case 2:
				parentNodeList = dom.getElementsByTagName("Detail2");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++) 
				{
					boolean isError = false;
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName == null)
					{
						continue;
					}
					childNodeName = childNodeName.trim();

					switch(childNodeName)
					{
					case "acct_prd":
					{
						acctPrd = whenNull(genericUtility.getColumnValue("acct_prd", dom));
						BaseLogger.log("3", getUserInfo(), null, "acct Prd>>>>>>"+acctPrd);
						if(acctPrd == null || acctPrd.trim().length() == 0)
						{
							BaseLogger.log("3", getUserInfo(), null, "acct Prd>>>>>>>"+acctPrd);	
							if("E".equalsIgnoreCase(whenNull(insertError("VTACCTPRD1", childNodeName))))
							{
								isError = true;
								break;
							}
						}
						else
						{
							sql = "SELECT COUNT(*) FROM ACCTPRD WHERE CODE = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,acctPrd);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0) 
							{
								if("E".equalsIgnoreCase(whenNull(insertError("VTACCTPRD1", childNodeName))))
								{
									isError = true;
									break;
								}
							}

						}
					}
					}
					if(isError)
					{
						break;
					}
				}
				break;
			case 3:
				parentNodeList = dom.getElementsByTagName("Detail3");
				parentNode = parentNodeList.item(0);
				childNodeList = parentNode.getChildNodes();
				childNodeListLength = childNodeList.getLength();
				for(ctr = 0; ctr < childNodeListLength; ctr++) 
				{
					boolean isError = false;
					childNode = childNodeList.item(ctr);
					childNodeName = childNode.getNodeName();
					if (childNodeName == null)
					{
						continue;
					}
					childNodeName = childNodeName.trim();
					BaseLogger.log("3", getUserInfo(), null, "childNodeName code>>>>>>>"+childNodeName);

					switch(childNodeName)
					{	
					case "tax_code":
					{
						taxCode = whenNull(getItemString(dom,1,"tax_code"));
						BaseLogger.log("3", getUserInfo(), null, "tax code>>>>>>>"+taxCode);

						if(taxCode == null || taxCode.trim().length() == 0)
						{
							BaseLogger.log("3", getUserInfo(), null, "tax code>>>>>>>"+taxCode);	
							if("E".equalsIgnoreCase(whenNull(insertError("VTTAX1", childNodeName))))
							{
								break;
							}
						}
						else
						{
							sql = "select count(1)  from tax where tax_code = ?";
							pstmt = conn.prepareStatement(sql);
							pstmt.setString(1,taxCode);
							rs = pstmt.executeQuery();
							if(rs.next())
							{
								cnt = rs.getInt(1);
							}
							rs.close();
							rs = null;
							pstmt.close();
							pstmt = null;
							if(cnt == 0)
							{
								if("E".equalsIgnoreCase(whenNull(insertError("VTTAX1", childNodeName))))
								{
									break;
								}
							}
						}
					}

					}
					if(isError)
					{
						break;
					}

				}
				break;
			}
		}
		catch(Exception e)
		{
			System.out.println("Exception : AssetRegisterIC : wfValData(String xmlString2) : ==>\n"+e.getMessage());
			throw new ITMException(e);
		}
		finally
		{
			try
			{
				if(conn != null)
				{
					conn.close();
					conn = null;
				}
			}
			catch(Exception d)
			{
				d.printStackTrace();
			}			
		}
		return errString;
	}
	private String checkNull(String input) 
	{
		if(input == null)
		{
			input = "";
		}
		return input;
	}

	public String itemChanged(Document dom, Document dom1, Document dom2, String objContext, String currentColumn, String editFlag, String xtraParams) throws RemoteException, ITMException
	{
		String sql="",descr="", lsStr1 = "",  lsGrpCode = "", lsStr2 = "", lsGrpDescr = "", lsSitecode = "", lsFinEntity = "", lsAssetClass = "", lsItemCode = "", lsItemSer = "";
		String  loginSite="",lsCode = "",loginSiteCode="",lsItemGrp="",useDate="";
		String lsAssetCode=null;
		String deprtype;
		double lcExch=0.0, lcTotalValue=0.0, lcValue=0.0,  lcTotValueBc=0.0, lcDeprPerc1=0.0, lcDeprPerc2 =0.0;
		double lcWdvAmt=0.0, lcOrgVal=0.0, lcDeprAmt2=0.0, lcDeprAmt=0.0, lcRevalAmt=0.0, lcDeprAmtRevl2=0.0, lcExchrate=0.0, lcUsefulLife=0.0;
		Timestamp  ldDate = null,  ldtUseDate = null, ldVar1 = null, ldtToday = null;
		int liCnt=0,as_form_no=0;
		ResultSet rs = null;
		pstmt = null;
		try
		{
			switch(objContext) {

			case "1":{
				SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
				conn = conn==null?getConnection():conn;
				currentColumn=currentColumn.toLowerCase();
				switch(currentColumn) {

				case "itm_defaultedit":
				{
					if(currentColumn.trim().equalsIgnoreCase("itm_defaultedit"))
					{
						gbfItemchgModifierDs(dom, "asset_code", "protect", "1");
					}
					break;
				}
				case "itm_default":{
					loginSite  = whenNull(getItemString(dom, 1, currentColumn));
					sql="select descr from site where site_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, loginSite);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						descr=rs.getString("descr");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;

					setItem(dom, 1, "site_code", loginSiteCode);
					setItem(dom, 1, "site_descr", descr);
					ldtToday = new Timestamp(System.currentTimeMillis());
					setItem(dom, 1, "rcp_date", sdf.format(ldtToday));
					setItem(dom, 1, "inst_date", sdf.format(ldtToday));
					setItem(dom, 1, "use_date", sdf.format(ldtToday));
					setItem(dom, 1, "proc_date_1", sdf.format(ldtToday));
					setItem(dom, 1, "proc_date_2", sdf.format(ldtToday));
					setItem(dom, 1, "verified_on", sdf.format(ldtToday));
					setItem(dom, 1, "orginal_value", "0");
					setItem(dom, 1, "status", "A");
					setItem(dom, 1, "depr_type", "N");
					setItem(dom, 1, "asset_type", "D");
					gbfItemchgModifierDs(dom, "asset_code", "protect", "0");

					break;
				}

				case "item_code":{
					lsCode  = whenNull(getItemString(dom, 1, currentColumn));
					sql="select descr, item_ser, grp_code from item where item_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						descr = rs.getString("descr");
						lsStr1 = rs.getString("item_ser");
						lsGrpCode = rs.getString("grp_code");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;

					setItem(dom, 1, "item_descr", descr);
					setItem(dom, 1, "item_ser", lsStr1);
					setItem(dom, 1, "grp_code", lsGrpCode);

					sql="select descr from itemser where item_ser = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsStr1);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lsStr2 = rs.getString("descr");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					setItem(dom, 1, "itemser_descr", lsStr2);

					sql="select descr from gencodes where fld_value = ? and fld_name = 'GRP_CODE'";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsGrpCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lsGrpDescr = rs.getString("descr");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					setItem(dom, 1, "gencodes_descr", lsGrpDescr);
					itemChanged(dom, dom1, dom2,objContext,"depr_method_1",editFlag, xtraParams);
					itemChanged(dom, dom1, dom2,objContext,"depr_method_2", editFlag, xtraParams);
					lsSitecode = getItemString(dom, 1, "site_code");
					sql="select fin_entity from  site where site_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsSitecode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lsFinEntity = rs.getString("fin_entity");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;

					sql="select count(*) from asset_class where item_ser = ? and grp_code = ? and  fin_entity = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsStr1);
					pstmt.setString(2, lsGrpCode);
					pstmt.setString(3, lsFinEntity);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						liCnt = rs.getInt(1);
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					if(liCnt > 0)
					{
						sql="select asset_class ,useful_life from asset_class where item_ser =? and  grp_code = ? and  fin_entity = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, lsStr1);
						pstmt.setString(2, lsGrpCode);
						pstmt.setString(3, lsFinEntity);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							lsAssetClass = rs.getString("asset_class");
							lcUsefulLife = rs.getDouble("useful_life");
						}
						pstmt.close();
						pstmt=null;
						rs.close();
						rs=null;
					}
					else
					{
						sql="select asset_class ,useful_life from asset_class where item_ser = ? and  grp_code = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, lsStr1);
						pstmt.setString(2, lsGrpCode);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							lsAssetClass = rs.getString("asset_class");
							lcUsefulLife = rs.getDouble("useful_life");
						}
						pstmt.close();
						pstmt=null;
						rs.close();
						rs=null;
					}
					setItem(dom, 1, "asset_class", lsAssetClass);
					setItem(dom, 1, "useful_life", String.valueOf(lcUsefulLife));

					break;
				}
				case "grp_code":{
					lsCode  = whenNull(getItemString(dom, 1, currentColumn));
					sql="select descr  from gencodes where fld_value = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						descr = rs.getString("descr");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					setItem(dom, 1, "gencodes_descr", descr);
					itemChanged(dom, dom1, dom2,objContext,"depr_method_1",editFlag, xtraParams);
					itemChanged(dom, dom1, dom2,objContext,"depr_method_2", editFlag, xtraParams);

					break;
				}
				case "aloc_code":{
					lsCode  = whenNull(getItemString(dom, 1, currentColumn));
					lsSitecode = getItemString(dom, 1, "site_code");
					sql="select descr from asset_location where aloc_code = ? OR site_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsCode);
					pstmt.setString(2, lsSitecode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						descr = rs.getString("descr");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					setItem(dom, 1, "location_descr", descr);

					break;
				}
				case "site_code":{

					lsCode  = whenNull(getItemString(dom, 1, currentColumn));
					sql="select descr from site where site_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						descr = rs.getString("descr");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					setItem(dom, 1, "site_descr", descr);

					break;
				}
				case "supp_code":{
					lsCode  = whenNull(getItemString(dom, 1, currentColumn));
					sql="select supp_name,curr_code from supplier where supp_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						descr = rs.getString("supp_name");
						lsStr1 = rs.getString("curr_code");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					setItem(dom, 1, "supp_name", descr);
					setItem(dom, 1, "curr_code", lsStr1);

					sql="select std_exrt from currency where curr_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsStr1);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lcExch = rs.getDouble("std_exrt");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					setItem(dom, 1, "exch_rate", lcExch);

					break;
				}
				case "rcp_date":{
					String rcpDate = whenNull(getItemString(dom, 1, currentColumn));
					if(rcpDate!=null&& rcpDate.trim().isEmpty()) 
					{
						ldDate = Timestamp.valueOf(genericUtility.getValidDateString(rcpDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00");
					}
					if(ldDate!=null)
					{
						setItem(dom, 1, "inst_date", sdf.format(ldDate));
						setItem(dom, 1, "use_date", sdf.format(ldDate));
						setItem(dom, 1, "proc_date_1", sdf.format(ldDate));
						setItem(dom, 1, "proc_date_2", sdf.format(ldDate));
					}
					else {
						setItem(dom, 1, "inst_date", "");
						setItem(dom, 1, "use_date","");
						setItem(dom, 1, "proc_date_1", "");
						setItem(dom, 1, "proc_date_2", "");

					}
					itemChanged(dom, dom1, dom2,objContext,"depr_method_1",editFlag, xtraParams);
					itemChanged(dom, dom1, dom2,objContext,"depr_method_2", editFlag, xtraParams);

					break;
				}

				case "use_date":{

					useDate = whenNull(getItemString(dom, 1, currentColumn));
					if(useDate!=null && useDate.trim().length() > 0)
					{
						ldDate =Timestamp.valueOf(genericUtility.getValidDateString(useDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00");
					}
					if(ldDate!=null)
					{
						setItem(dom, 1, "proc_date_1", sdf.format(ldDate));
						setItem(dom, 1, "proc_date_2", sdf.format(ldDate));
					}
					else
					{
						setItem(dom, 1, "proc_date_1","");
						setItem(dom, 1, "proc_date_2","");
					}
					itemChanged(dom, dom1, dom2,objContext,"depr_method_1",editFlag, xtraParams);
					itemChanged(dom, dom1, dom2,objContext,"depr_method_2", editFlag, xtraParams);

					break;
				}

				case "orginal_value":
				case "other_chgs":
				case "tax_amt":
				case "revalue_amt":
				case "diff_amt__exch":
				case "install_chgs":
				case "comm_chgs":
				case "insur_chgs":
				case "exch_rate":
				case "octroi_chgs":
				{		
					double originalval = 0.0,otherchanges1=0.0,taxamt1=0.0,revalueamt1=0.0, diffamtexch1=0.0,
							install_chgs1=0.0,commchgs1=0.0,insurchgs1=0.0,octroichgs1=0.0;

					String originalvalue=whenNull(getItemString(dom, 1, "orginal_value"));
					String otherchanges =whenNull(getItemString(dom, 1, "other_chgs"));
					String taxamt=whenNull(getItemString(dom, 1, "tax_amt"));
					String revalueamt=whenNull(getItemString(dom, 1, "revalue_amt"));
					String diffamtexch=whenNull(getItemString(dom, 1, "diff_amt__exch"));
					String install_chgs=whenNull(getItemString(dom, 1, "install_chgs"));
					String commchgs=whenNull(getItemString(dom, 1, "comm_chgs"));
					String insurchgs =whenNull(getItemString(dom, 1, "insur_chgs"));
					String octroichgs=whenNull(getItemString(dom, 1, "octroi_chgs"));

					if(originalvalue != null && originalvalue.trim().length() > 0)
					{
						originalval = Double.parseDouble(originalvalue);
					}
					if(otherchanges != null && otherchanges.trim().length() > 0)
					{
						otherchanges1 = Double.parseDouble(otherchanges);
					}
					if(taxamt != null && taxamt.trim().length() > 0)
					{
						taxamt1 = Double.parseDouble(taxamt);
					}
					if(revalueamt != null && revalueamt.trim().length() > 0)
					{
						revalueamt1 = Double.parseDouble(revalueamt);
					}
					if(diffamtexch != null && diffamtexch.trim().length() > 0)
					{
						diffamtexch1 = Double.parseDouble(diffamtexch);
					}
					if(install_chgs != null && install_chgs.trim().length() > 0)
					{
						install_chgs1 = Double.parseDouble(taxamt);
					}
					if(commchgs != null && commchgs.trim().length() > 0)
					{
						commchgs1 = Double.parseDouble(commchgs);
					}
					if(insurchgs != null && insurchgs.trim().length() > 0)
					{
						insurchgs1 = Double.parseDouble(insurchgs);
					}
					if(octroichgs != null && octroichgs.trim().length() > 0)
					{
						octroichgs1 = Double.parseDouble(octroichgs);
					}

					lcTotalValue = originalval+otherchanges1+ taxamt1+revalueamt1+ diffamtexch1+ install_chgs1
							+ commchgs1+insurchgs1+octroichgs1;

					setItem(dom, 1, "total_value",lcTotalValue);
					setItem(dom, 1, "wdv_amt_1", lcTotalValue);
					setItem(dom, 1, "wdv_amt_2",lcTotalValue);

					if(lcTotalValue < 5000)
					{
						useDate = whenNull(getItemString(dom, 1, currentColumn));
						if(useDate!=null&& useDate.trim().isEmpty()) 
						{
							ldtUseDate = Timestamp.valueOf(genericUtility.getValidDateString(useDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00");
						}
						sql="select to_date  from acctprd where ? between fr_date and to_date";
						pstmt = conn.prepareStatement(sql);
						pstmt.setTimestamp(1, ldtUseDate);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							ldVar1 = rs.getTimestamp("to_date");
						}
						pstmt.close();
						pstmt=null;
						rs.close();
						rs=null;
						if(ldtUseDate != null)
						{
							if(daysAfter(sdf.format(ldtUseDate),sdf.format(ldVar1)) > 180)
							{
								setItem(dom, 1, "depr_perc_1", "100");
							}
						}			
						else
						{
							setItem(dom, 1, "depr_perc_1", "50");
						}	
						String totValueSTrr = whenNull(getItemString(dom, 1, "total_value"));
						if(totValueSTrr != null && totValueSTrr.trim().length() > 0)
						{
							lcTotValueBc = Double.parseDouble(totValueSTrr);
						}

						setItem(dom, 1, "tot_value__bc", lcTotValueBc);
					}
					break;
				}
				case "depr_method_1":{

					lsCode = whenNull(getItemString(dom, 1, currentColumn)).trim();
					lsGrpCode = getItemString(dom1, 1, "grp_code");
					lsItemSer = getItemString(dom1, 1, "item_ser");
					deprtype=getItemString(dom1, 1, "depr_type");
					useDate = whenNull(getItemString(dom, 1, "use_date"));
					if(useDate!=null&& useDate.trim().isEmpty())
					{
						ldtUseDate = Timestamp.valueOf(genericUtility.getValidDateString(useDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00");

					}
					sql="select depr_perc from depr_itemgrp where item_grp = ? and depr_method = ? and purpose = 'I' and ? between eff_from and valid_upto";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsGrpCode);
					pstmt.setString(2, lsCode);
					pstmt.setTimestamp(3, ldtUseDate);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lcDeprPerc1 = rs.getDouble("depr_perc");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					if(lcDeprPerc1 <= 0)
					{
						sql="select depr_perc from depr_itemser where item_ser = ? and depr_method = ? and purpose = 'I' and ? between eff_from and valid_upto";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, lsItemSer);
						pstmt.setString(2, lsCode);
						pstmt.setTimestamp(3, ldtUseDate);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							lcDeprPerc1 = rs.getDouble("depr_perc");
						}
						pstmt.close();
						pstmt=null;
						rs.close();
						rs=null;
					}

					setItem(dom, 1, "depr_perc_1",lcDeprPerc1);
					break;
				}

				case "depr_method_2":{
					lsCode = whenNull(getItemString(dom, 1, currentColumn)).trim();
					lsGrpCode = getItemString(dom1, 1, "grp_code");
					lsItemSer = getItemString(dom1, 1, "item_ser");
					deprtype=getItemString(dom1, 1, "depr_type");
					useDate = whenNull(getItemString(dom, 1, "use_date"));
					if(useDate!=null&& useDate.trim().isEmpty()) 
					{
						ldtUseDate = Timestamp.valueOf(genericUtility.getValidDateString(useDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00");
					}
					sql="select depr_perc from depr_itemgrp where item_grp = ? and depr_method = ? and purpose = 'C' and ? between eff_from and valid_upto";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsGrpCode);
					pstmt.setString(2, lsCode);
					pstmt.setTimestamp(3, ldtUseDate);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lcDeprPerc2 = rs.getDouble("depr_perc");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					if( lcDeprPerc2 <= 0)		
					{
						sql="select depr_perc from depr_itemser where item_ser =? and depr_method = ? and purpose = 'C' and ? between eff_from and valid_upto";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, lsItemSer);
						pstmt.setString(2, lsCode);
						pstmt.setTimestamp(3, ldtUseDate);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							lcDeprPerc2 = rs.getDouble("depr_perc");
						}
						pstmt.close();
						pstmt=null;
						rs.close();
						rs=null;
					}

					setItem(dom, 1, "depr_perc_2", lcDeprPerc2);

					break;
				}
				case "wdv_amt_2":
				case "wdv_amt_revl_2":
				{
					String lcWdvAmt1=whenNull(getItemString(dom, 1, currentColumn));
					if(lcWdvAmt1 != null && lcWdvAmt1.trim().length() > 0)
					{
						lcWdvAmt = Double.parseDouble(lcWdvAmt1);
					}
					String originalvalue=whenNull(getItemString(dom, 1, "orginal_value"));
					String revalueamt=whenNull(getItemString(dom, 1, "revalue_amt"));
					lsAssetCode = whenNull(getItemString(dom,1,"asset_code"));
					if(currentColumn.trim().equalsIgnoreCase("wdv_amt_2"))
					{
						lcOrgVal   = Double.parseDouble(originalvalue);
						lcDeprAmt2 = lcOrgVal - lcWdvAmt;
						setItem(dom, 1, "depr_amt_2", lcDeprAmt2);
					}
					else
					{
						lcRevalAmt = Double.parseDouble(revalueamt);
						lcDeprAmtRevl2 = lcRevalAmt - lcWdvAmt;
						setItem(dom, 1, "depr_amt_revl_2", lcDeprAmtRevl2);
					}

					break;
				}

				case "depr_amt_2":
				case "depr_amt_revl_2":
				{
					String originalvalue=whenNull(getItemString(dom, 1, "orginal_value"));
					String revalueamt=whenNull(getItemString(dom, 1, "revalue_amt"));
					String lcWdvAmt1=whenNull(getItemString(dom, 1, currentColumn));
					if(lcWdvAmt1 != null && lcWdvAmt1.trim().length() > 0)
					{
						lcWdvAmt = Double.parseDouble(lcWdvAmt1);
						lsAssetCode = whenNull(getItemString(dom,1,"asset_code"));
						if(currentColumn.trim().equalsIgnoreCase("depr_amt_2"))
						{
							lcOrgVal  = Double.parseDouble(originalvalue);
							lcWdvAmt  = lcOrgVal - lcDeprAmt;
							setItem(dom, 1, "wdv_amt_2", lcWdvAmt);
						}
					}
					else
					{
						lcRevalAmt = Double.parseDouble(revalueamt);
						lcWdvAmt = lcRevalAmt - lcDeprAmt;
						setItem(dom, 1, "wdv_amt_revl_2", lcWdvAmt);
					}

					break;
				}
				case "curr_code":{

					lsCode = getItemString(dom, 1, currentColumn);
					lsSitecode = getItemString(dom, 1, "site_code");
					sql="select std_exrt from currency where curr_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lcExchrate = rs.getDouble("std_exrt");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					setItem(dom, 1, "exch_rate",lcExchrate);
					sql="select finent.curr_code from  site, finent where ( site.fin_entity = finent.fin_entity ) and  ( site.site_code = ?)";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsSitecode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lsStr1 = rs.getString("curr_code");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					if(lsStr1.trim().equalsIgnoreCase(lsCode.trim()))
					{
						gbfItemchgModifierDs(dom, "exch_rate", "protect", "1");
					}
					else
					{
						gbfItemchgModifierDs(dom, "exch_rate", "protect", "0");
					}

					break;
				}
				case "asset_class":{

					lsAssetClass = whenNull(getItemString(dom, 1, "asset_class")).trim();
					lsItemCode = whenNull(getItemString(dom, 1, "item_code")).trim();
					lsGrpCode = whenNull(getItemString(dom, 1, "grp_code")).trim();
					lsSitecode = getItemString(dom, 1, "site_code");
					sql="select item_ser from item where item.item_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsItemCode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lsItemSer = rs.getString("item_ser");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					sql="select fin_entity from  site where site_code = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsSitecode);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						lsFinEntity = rs.getString("fin_entity");
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					sql="select count(*) from asset_class where item_ser =? and  grp_code =? and  fin_entity = ? and asset_class = ?";
					pstmt = conn.prepareStatement(sql);
					pstmt.setString(1, lsItemSer);
					pstmt.setString(2, lsGrpCode);
					pstmt.setString(3, lsFinEntity);
					pstmt.setString(4, lsAssetClass);
					rs = pstmt.executeQuery();
					if(rs.next())
					{
						liCnt = rs.getInt(1);
					}
					pstmt.close();
					pstmt=null;
					rs.close();
					rs=null;
					if(liCnt > 0)
					{
						sql="select useful_life from asset_class where item_ser = ? and  grp_code = ? and  fin_entity =? and asset_class =?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, lsItemSer);
						pstmt.setString(2, lsGrpCode);
						pstmt.setString(3, lsFinEntity);
						pstmt.setString(4, lsAssetClass);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							lcUsefulLife = rs.getDouble("useful_life");
						}
						pstmt.close();
						pstmt=null;
						rs.close();
						rs=null;
					}
					else
					{
						sql="select useful_life from asset_class where item_ser = ? and  grp_code = ? and asset_class = ?";
						pstmt = conn.prepareStatement(sql);
						pstmt.setString(1, lsItemSer);
						pstmt.setString(2, lsGrpCode);
						pstmt.setString(3, lsAssetClass);
						rs = pstmt.executeQuery();
						if(rs.next())
						{
							lcUsefulLife = rs.getDouble("useful_life");
						}
						pstmt.close();
						pstmt=null;
						rs.close();
						rs=null;
					}
					setItem(dom, 1, "useful_life", lcUsefulLife);
					break;
				}
				}
				break;
			}

			case "2": {
				switch(currentColumn) {
				case "itm_default":{

					lsAssetCode = getItemString(dom1, 1, "asset_code");
					setItem(dom, 1, "asset_code", lsAssetCode);
				}
				break;

				case "depr_method_1":{

					lsCode = getItemString(dom, 1, "depr_method_1");
					lsItemGrp = getItemString(dom1, 1, "grp_code");
					lsItemSer = getItemString(dom1, 1, "item_ser");
					useDate = whenNull(getItemString(dom, 1, "use_date"));
					if(useDate != null && useDate.trim().length() > 0)
					{
						ldtUseDate = Timestamp.valueOf(genericUtility.getValidDateString(useDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00");

					}
					sql="select depr_perc from depr_itemgrp where item_grp = ? and depr_method = ? and purpose = 'I'  and ? between eff_from and valid_upto ";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1, lsItemGrp);
					pstmt.setString(2, lsCode);
					pstmt.setTimestamp(3, ldtUseDate);
					rs=pstmt.executeQuery();
					if(rs.next()) 
					{
						lcDeprPerc1=rs.getDouble("depr_perc");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					if (lcDeprPerc1 <= 0) 
					{
						sql="select depr_perc from depr_itemser where item_ser = ? and depr_method = ? and purpose = 'I' and ? between eff_from and valid_upto";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1, lsItemSer);
						pstmt.setString(2, lsCode);
						pstmt.setTimestamp(3, ldtUseDate);
						rs=pstmt.executeQuery();
						if(rs.next()) 
						{
							lcDeprPerc1=rs.getDouble("depr_perc");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}

					setItem(dom, 1, "depr_perc_1", lcDeprPerc1);
					break;

				}
				case "depr_method_2":{

					lsCode = getItemString(dom, 1, "depr_method_2");
					lsItemGrp = getItemString(dom1, 1, "grp_code");
					lsItemSer = getItemString(dom1, 1, "item_ser");
					useDate = whenNull(getItemString(dom, 1, "use_date"));
					ldtUseDate = Timestamp.valueOf(genericUtility.getValidDateString(useDate, genericUtility.getApplDateFormat(), genericUtility.getDBDateFormat()) + " 00:00:00");
					sql="select depr_perc from depr_itemgrp where item_grp = ? and depr_method = ? and purpose = 'C'  and ? between eff_from and valid_upto ";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1, lsItemGrp);
					pstmt.setString(2, lsCode);
					pstmt.setTimestamp(3, ldtUseDate);
					rs=pstmt.executeQuery();
					if(rs.next()) 
					{
						lcDeprPerc2=rs.getDouble("depr_perc");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;

					if (lcDeprPerc2 <= 0) 
					{
						sql="select depr_perc from depr_itemser where item_ser = ? and depr_method = ? and purpose = 'C' and ? between eff_from and valid_upto";
						pstmt=conn.prepareStatement(sql);
						pstmt.setString(1, lsItemSer);
						pstmt.setString(2, lsCode);
						pstmt.setTimestamp(3, ldtUseDate);
						rs=pstmt.executeQuery();
						if(rs.next()) 
						{
							lcDeprPerc2=rs.getDouble("depr_perc");
						}
						rs.close();
						rs = null;
						pstmt.close();
						pstmt = null;
					}
					setItem(dom, 1, "depr_perc_2", lcDeprPerc2);
					break;
				}
				}

				break;
			}

			case "3": {
				switch(currentColumn) {
				case "tax_code":{

					lsCode = getItemString(dom, 1, "tax_code");
					sql="select descr from tax where tax_code = ?";
					pstmt=conn.prepareStatement(sql);
					pstmt.setString(1, lsCode);
					rs=pstmt.executeQuery();
					if(rs.next()) 
					{
						descr=rs.getString("descr");
					}
					rs.close();
					rs = null;
					pstmt.close();
					pstmt = null;
					setItem(dom, 1, "tax_descr", descr);

					break;
				}
				}
				break;
			}
			}
		}
		catch (Exception e)
		{
			e.printStackTrace();
			throw new ITMException(e);
		} 
		finally 
		{
			try {
				if (conn != null)
				{
					if (rs != null) 
					{
						rs.close();
						rs = null;
					}
					if (pstmt != null)
					{
						pstmt.close();
						pstmt = null;
					}

				}
			} catch (Exception d) {
				d.printStackTrace();
				throw new ITMException(d);
			}
		}
		return "";
	}
	public String whenNull(String str)
	{
		if(str==null)
		{
			return "";
		}
		else
		{
			return str;
		}
	}
	private int daysAfter(String fromDateStr, String toDateStr) throws Exception
	{
		fromDateStr=fromDateStr==null?"":fromDateStr;
		toDateStr=toDateStr==null?"":toDateStr;

		if(fromDateStr.length() <= 0 || toDateStr.length() <= 0)
		{
			return 0;
		}

		SimpleDateFormat sdf = new SimpleDateFormat(genericUtility.getApplDateFormat());
		Date fromDate = sdf.parse(fromDateStr); 
		Date toDate = sdf.parse(toDateStr);
		return (int)( (toDate.getTime() - fromDate.getTime() ) / (1000 * 60 * 60 * 24) );
	}
}